#include <iostream>
#include <vector>
#include <stack>
#include <algorithm>

using namespace std;

const int INF = 1e9;

struct Room {
    int id;
    int strength;
    int jumps;
};

vector<vector<int>> adj;
vector<int> hasPlatform;
vector<int> platformChanges;
vector<int> result;

void dfs(int node, vector<Room>& rooms) {
    stack<Room> st;
    st.push({node, 0, 0});

    while (!st.empty()) {
        Room current = st.top();
        st.pop();

        result[current.id] = current.jumps;

        for (int neighbor : adj[current.id]) {
            if (hasPlatform[neighbor] || platformChanges[neighbor] == 0) {
                // If the neighbor has a platform or the platform is not changed, the rabbit can jump to it
                st.push({neighbor, rooms[neighbor].strength, current.jumps + 1});
            }
        }
    }
}

int main() {
    int N;
    cin >> N;

    adj.resize(N + 1);
    hasPlatform.resize(N + 1);
    platformChanges.resize(N + 1);
    result.resize(N + 1, -1);

    vector<Room> rooms(N + 1);

    for (int i = 1; i < N; ++i) {
        int Ui, Vi;
        cin >> Ui >> Vi;
        adj[Vi].push_back(Ui);
    }

    for (int i = 1; i <= N; ++i) {
        cin >> hasPlatform[i];
    }

    for (int i = 1; i <= N; ++i) {
        cin >> platformChanges[i];
    }

    // Starting from the last rabbit and going backward
    for (int i = N; i >= 1; --i) {
        dfs(i, rooms);

        // Apply changes in jumping platforms
        if (i > 1) {
            int changedRoom = platformChanges[i];
            hasPlatform[changedRoom] = 1 - hasPlatform[changedRoom];
        }
    }

    for (int i = 1; i <= N; ++i) {
        cout << result[i] << " ";
    }

    return 0;
}